package com.burhanstore.neonbubblequest

import android.app.Activity
import android.app.Application
import android.os.Bundle
import com.burhanstore.neonbubblequest.Utils.AppString
import com.burhanstore.neonbubblequest.Utils.appuser.UserManager
import com.google.firebase.FirebaseApp
import com.onesignal.OneSignal
import com.onesignal.debug.LogLevel
import kotlinx.coroutines.CoroutineScope
import kotlinx.coroutines.Dispatchers
import kotlinx.coroutines.launch

class Application : Application(), Application.ActivityLifecycleCallbacks {
    override fun onActivityCreated(
        activity: Activity,
        savedInstanceState: Bundle?
    ) {
        TODO("Not yet implemented")
    }

    override fun onActivityDestroyed(activity: Activity) {

    }

    override fun onActivityPaused(activity: Activity) {

    }

    override fun onActivityResumed(activity: Activity) {

    }

    override fun onActivitySaveInstanceState(
        activity: Activity,
        outState: Bundle
    ) {

    }

    override fun onActivityStarted(activity: Activity) {

    }

    override fun onActivityStopped(activity: Activity) {

    }


    companion object {
        lateinit var instance: com.burhanstore.neonbubblequest.Application
            private set
    }

    override fun onCreate() {
        super.onCreate()
        instance = this

        // Initialize Firebase
        FirebaseApp.initializeApp(this)
        initOneSignal()
    }


    private fun initOneSignal() {

        val reader =
            AppString.JsonReader(UserManager.getInstance(instance).getSetting()?.app_config ?: "")
        val onesignal_app_id = reader.get("onesignal_app_id")


        OneSignal.Debug.logLevel = LogLevel.VERBOSE
        OneSignal.initWithContext(this, onesignal_app_id)
        CoroutineScope(Dispatchers.IO).launch {
            OneSignal.Notifications.requestPermission(true)
        }


    }
}
